/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.access.api.AcaClient;
import com.ibm.hsc.access.api.AcaUtils;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.AccUtils;
import com.ibm.hsc.common.util.HscPasswordMgr;
import com.ibm.hsc.common.util.PIUserUtils;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class PIHMCUserCreate {
    private static final String[] m_validOpts = new String[]{HMCCommandUtils.USER_NAME_PARAM, HMCCommandUtils.ADD_ACCESS_PARAM, HMCCommandUtils.DESCRIPTION_PARAM, HMCCommandUtils.HELP_PARAM, "--passwd", "-M"};
    private String m_login = null;
    private String m_description = "HMC User";
    private String m_role = null;
    private String m_newPasswd = null;
    private String m_expireDays = null;
    private String m_retypePasswd = null;
    private String m_deleteCmd = null;
    private AcaClient m_acaCl = null;
    private boolean m_GUIUser = false;

    private void validateExecResult(EExecResult eExecResult) throws PIHscClientException {
        String[] stringArray = new String[2];
        if (eExecResult.rc != 0) {
            PIUserUtils.logSysEvent((short)2102, stringArray);
            String[] stringArray2 = new String[2];
            if (eExecResult.rc == 109) {
                throw new PIHscClientException("232A", "PIHscCmdLineBundle", "USER_ALREADY_EXISTS");
            }
            String[] stringArray3 = new String[]{"(rc=" + eExecResult.rc + "). " + eExecResult.stderr};
            throw new PIHscClientException("232E", "PIHscCmdLineBundle", "USER_CREATE_FAILED", stringArray3, new Throwable());
        }
    }

    private void printACMMessage() {
        if (this.m_acaCl == null) {
            AccUtils.SHOW("AcaClient is not initialized!");
            return;
        }
        AccUtils.SHOW(this.m_acaCl.GetMessage());
    }

    private void initAcaClient() {
        AccUtils.DBG("initAcaClient");
        try {
            if (this.m_acaCl == null) {
                this.m_acaCl = new AcaClient(2);
            }
        }
        catch (IOException iOException) {
            if (IDebug.enabled()) {
                iOException.printStackTrace();
            }
            this.printACMMessage();
            this.m_acaCl = null;
        }
    }

    private void deleteUser() {
        if (this.m_deleteCmd != null && this.m_deleteCmd.length() > 0) {
            EExecResult eExecResult = EExec.Exec((String)this.m_deleteCmd);
        }
    }

    private boolean getUserPassword() {
        try {
            EExecResult eExecResult;
            String string = System.getProperty("HMCtty.name");
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            if (string != null && string != "") {
                eExecResult = EExec.Exec((String)("stty --save --file=" + string));
                string2 = "stty --file=" + string + " " + eExecResult.stdout;
                string3 = "stty --file=" + string + " -echo";
                bl = true;
            }
            Object[] objectArray = new String[]{this.m_login};
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ENTER_NEW_PASSWORD", null, objectArray));
            if (bl) {
                eExecResult = EExec.Exec(string3);
            }
            this.m_newPasswd = bufferedReader.readLine().trim();
            if (bl) {
                eExecResult = EExec.Exec((String)string2);
            }
            AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "REENTER_NEW_PASSWORD", null, objectArray));
            if (bl) {
                eExecResult = EExec.Exec((String)string3);
            }
            this.m_retypePasswd = bufferedReader.readLine().trim();
            if (bl) {
                eExecResult = EExec.Exec((String)string2);
            }
            bufferedReader.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean registerACM() {
        String[] stringArray = new String[]{this.m_role};
        int n = this.m_acaCl.RegisterUser(this.m_login, stringArray);
        if (n != 0) {
            this.printACMMessage();
            return false;
        }
        return true;
    }

    private boolean changeHscrootPassword() {
        try {
            String string = PIUserUtils.buildModifyEncrptPasswd(this.m_login, this.m_newPasswd);
            int n = 0;
            try {
                Process process = Runtime.getRuntime().exec(string);
                n = process.waitFor();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (n != 0) {
                return false;
            }
            AccUtils.DBG("Check for HSC special user ...");
            if ("hscroot".equals(this.m_login)) {
                AccUtils.DBG("Saving password ...");
                if (HscPasswordMgr.setPassword(this.m_login, this.m_newPasswd) != 0) {
                    AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "USER_SET_PASSWORD_ERROR"));
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean createHscrootUser() {
        if (PIUserUtils.isUserExist(this.m_login)) {
            AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "USER_ALREADY_EXISTS"));
            return false;
        }
        boolean bl = true;
        try {
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[]{"root"};
            stringArray[0] = "hmcsuperadmin";
            String string = "HMC Super User";
            String string2 = PIUserUtils.buildCreateCmd(this.m_login, string, stringArray, stringArray2);
            EExecResult eExecResult = EExec.Exec((String)string2);
            PIUserUtils.printExecResult(eExecResult);
            if (eExecResult.rc != 0) {
                AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "USER_CREATE_FAILED"));
                return false;
            }
            AccUtils.DBG("Setting/and Saving password");
            if (!this.changeHscrootPassword()) {
                AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "USER_SET_PASSWORD_ERROR"));
                return false;
            }
            AccUtils.DBG("Register user to ACM");
            if (this.m_acaCl != null) {
                int n = this.m_acaCl.RegisterUser(this.m_login, stringArray);
                if (this.m_login.equals("hscroot")) {
                    n = this.m_acaCl.RegisterUser("root", stringArray);
                }
                if (n != 0) {
                    this.printACMMessage();
                    return false;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "USER_CREATE_FAILED"));
            return false;
        }
        AccUtils.DBG("Out createHscrootUser()");
        return true;
    }

    private void createPredefinedUser() throws PIHscClientException {
        String string = "";
        String string2 = "";
        String string3 = "";
        Hashtable hashtable = new Hashtable();
        String[] stringArray = new String[2];
        stringArray[0] = this.m_login;
        PIUserUtils.validateLogin(this.m_login);
        PIUserUtils.validatePasswordInput(this.m_newPasswd, true);
        String[] stringArray2 = new String[]{this.m_role};
        stringArray[1] = stringArray2[0];
        String[] stringArray3 = null;
        string3 = PIUserUtils.buildCreateCmd(this.m_login, this.m_description, stringArray2, stringArray3);
        EExecResult eExecResult = EExec.Exec((String)string3);
        PIUserUtils.printExecResult(eExecResult);
        this.validateExecResult(eExecResult);
        if (this.m_login.length() > 0) {
            this.m_deleteCmd = PIUserUtils.buildDeleteCmd(this.m_login);
        }
        string3 = PIUserUtils.buildModifyEncrptPasswd(this.m_login, this.m_newPasswd);
        int n = 0;
        try {
            Process process = Runtime.getRuntime().exec(string3);
            n = process.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n == 0) {
            PIUserUtils.logSysEvent((short)2101, stringArray);
        }
    }

    private void createNormalUser() throws PIHscClientException {
        String[] stringArray;
        String string = "";
        String string2 = "";
        String string3 = "";
        Hashtable hashtable = new Hashtable();
        String[] stringArray2 = new String[2];
        stringArray2[0] = this.m_login;
        PIUserUtils.validateLogin(this.m_login);
        if (!this.m_acaCl.isValidRole(this.m_role)) {
            stringArray = this.m_role;
            AccUtils.throwCmdLineSyntaxError((String)stringArray, "USER_INVALID_ROLE");
        }
        stringArray = new String[]{this.m_role};
        stringArray2[1] = stringArray[0];
        String[] stringArray3 = null;
        string3 = PIUserUtils.buildCreateCmd(this.m_login, this.m_description, stringArray, stringArray3);
        EExecResult eExecResult = EExec.Exec((String)string3);
        PIUserUtils.printExecResult(eExecResult);
        this.validateExecResult(eExecResult);
        if (this.m_login.length() > 0) {
            this.m_deleteCmd = PIUserUtils.buildDeleteCmd(this.m_login);
        }
        if (this.m_expireDays.length() > 0) {
            PIUserUtils.setPasswdExpiration(this.m_login, this.m_expireDays);
        }
        if (!(this.m_newPasswd != null && this.m_newPasswd.length() > 0 || this.getUserPassword())) {
            throw new PIHscClientException("8014", "PIHscCmdLineBundle", "ERROR_READING_PASSWORD");
        }
        PIUserUtils.validatePasswordInput(this.m_login, this.m_newPasswd, this.m_retypePasswd);
        string3 = PIUserUtils.buildModifyEncrptPasswd(this.m_login, this.m_newPasswd);
        int n = 0;
        try {
            Process process = Runtime.getRuntime().exec(string3);
            n = process.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n == 0) {
            this.registerACM();
            PIUserUtils.logSysEvent((short)2101, stringArray2);
        }
    }

    private void mapParameters(HashMap hashMap) throws PIHscClientException {
        String[] stringArray;
        Object var2_2 = null;
        String string = AccUtils.validateCmdOptions(m_validOpts, hashMap);
        if (string != null && string.length() > 0) {
            AccUtils.throwCmdLineSyntaxError(string, "INVALID_PARM");
        }
        this.m_login = (String)hashMap.get(HMCCommandUtils.USER_NAME_PARAM);
        if (this.m_login != null) {
            this.m_login = this.m_login.trim();
        }
        this.m_role = (String)hashMap.get(HMCCommandUtils.ADD_ACCESS_PARAM);
        if (this.m_role != null) {
            this.m_role = this.m_role.trim();
        }
        this.m_description = (String)hashMap.get(HMCCommandUtils.DESCRIPTION_PARAM);
        if (this.m_description != null) {
            this.m_description = PIUserUtils.isValidUserDescription(this.m_description);
        }
        if (this.m_description == null || this.m_description.length() <= 0) {
            this.m_description = "HMC User";
        }
        this.m_expireDays = (String)hashMap.get("-M");
        if (this.m_expireDays != null && this.m_expireDays.length() > 0) {
            if (!PIUserUtils.isValidPasswordAge(this.m_expireDays)) {
                stringArray = "-M " + this.m_expireDays;
                AccUtils.throwInvalidParm((String)stringArray);
            }
        } else {
            this.m_expireDays = "99999";
        }
        this.m_newPasswd = (String)hashMap.get("--passwd");
        if ((PIUserUtils.isHMCSuperUser(this.m_login) || this.m_GUIUser) && (this.m_newPasswd == null || this.m_newPasswd.length() <= 0)) {
            stringArray = new String[]{"--passwd"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, new Throwable());
        }
        if (this.m_newPasswd != null && this.m_newPasswd.length() > 0) {
            this.m_retypePasswd = this.m_newPasswd;
        }
        if (PIUserUtils.isHMCSuperUser(this.m_login) && (this.m_role == null || this.m_role.length() <= 0)) {
            this.m_role = "hmcsuperadmin";
        }
        if (this.m_login == null || this.m_role == null) {
            stringArray = new String[]{this.m_login == null ? HMCCommandUtils.USER_NAME_PARAM : HMCCommandUtils.ADD_ACCESS_PARAM};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, new Throwable());
        }
    }

    private void printHelp() {
        AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "HMCUSER_CREATE_HELP"));
    }

    public int createUserFromGUI(String[] stringArray) throws IOException, PIHscClientException, Exception {
        this.m_GUIUser = true;
        try {
            return this.createUser(stringArray);
        }
        catch (IOException iOException) {
            this.deleteUser();
            throw iOException;
        }
        catch (PIHscClientException pIHscClientException) {
            this.deleteUser();
            throw pIHscClientException;
        }
    }

    public int createUserFromGUI(Locale locale, String[] stringArray) throws IOException, Exception {
        this.m_GUIUser = true;
        try {
            return this.createUser(stringArray);
        }
        catch (IOException iOException) {
            this.deleteUser();
            throw iOException;
        }
        catch (PIHscClientException pIHscClientException) {
            this.deleteUser();
            AccUtils.DBG("\tloc  =" + locale);
            AccUtils.DBG("\tbundleName=" + pIHscClientException.getBundleName());
            AccUtils.DBG("\tmsgId     =" + pIHscClientException.getMsgId());
            AccUtils.DBG("\tERROR     =" + pIHscClientException.getMessage());
            AccUtils.DBG("\tArgs      =" + pIHscClientException.getArgs());
            String string = HSCResourceBundleUtil.getMessage(locale, pIHscClientException.getBundleName(), pIHscClientException.getMsgId(), null, pIHscClientException.getArgs(), true);
            throw new Exception(string);
        }
    }

    public int createUser(String[] stringArray) throws IOException, PIHscClientException {
        HashMap hashMap;
        Object var2_2 = null;
        Object var3_3 = null;
        if (stringArray.length == 0) {
            this.printHelp();
            return 1;
        }
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            arrayList.add(string);
            if (!string.equals(HMCCommandUtils.HELP_PARAM)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.printHelp();
            return 0;
        }
        try {
            hashMap = HMCCommandUtils.parseParameters(arrayList);
        }
        catch (RequiredParameterException requiredParameterException) {
            throw new PIHscClientException(requiredParameterException.getMessage());
        }
        this.mapParameters(hashMap);
        if (PIUserUtils.isHMCSuperUser(this.m_login)) {
            if (!this.createHscrootUser()) {
                return 1;
            }
            return 0;
        }
        if (AcaUtils.isPredefinedUser((String)this.m_login) && !AcaUtils.getPredefinedUserRole((String)this.m_login).equals(this.m_role)) {
            return 16;
        }
        this.initAcaClient();
        if (this.m_acaCl == null) {
            if (AcaUtils.isPredefinedUser((String)this.m_login)) {
                this.createPredefinedUser();
                return 0;
            }
            return 1;
        }
        this.createNormalUser();
        return 0;
    }

    public static void main(String[] stringArray) {
        PIHMCUserCreate pIHMCUserCreate = null;
        try {
            pIHMCUserCreate = new PIHMCUserCreate();
            int n = pIHMCUserCreate.createUser(stringArray);
            System.exit(n);
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                AccUtils.DBG("Get PIHscClientException!");
                ((Throwable)pIHscClientException).printStackTrace();
            }
            String string = pIHscClientException.getMessage();
            AccUtils.SHOW(string);
            if (pIHMCUserCreate != null) {
                pIHMCUserCreate.deleteUser();
            }
        }
        catch (IOException iOException) {
            AccUtils.DBG("Get IOException!");
            if (IDebug.enabled()) {
                iOException.printStackTrace();
            }
            if (pIHMCUserCreate != null) {
                pIHMCUserCreate.printACMMessage();
            }
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            if (pIHMCUserCreate != null) {
                pIHMCUserCreate.deleteUser();
            }
            String string = throwable.getMessage();
            AccUtils.SHOW(string);
        }
        System.exit(1);
    }
}

